# 1. In CMD, point to shared directory containing html files | 2.Start basic http server : python -m http.server 8000

import random, os, time, sys, glob, csv, logging, http.server, threading, shutil


def web_server():
    handler = http.server.SimpleHTTPRequestHandler
    server_address = ('192.168.150.1', 8000)
    httpd = http.server.HTTPServer(server_address, handler)
    thread = threading.Thread(target=httpd.serve_forever)
    thread.start()


def main_html(code, timed, tm, ts, latest_list, problem_list, error_log, refresh_page, what_time_is_it):
    """
    Will generate a static html file. The file auto refreshes every second or so

    The file is broken into 3 sections:
    1. The code that is generated (changes every 30 seconds or so)
    2. The last 4 devices to use a code (updates as the code changes)
    3. The devices that have used the most codes in a 6-month period (updates hourly give or take a minute or two)
    4. The buttons which will link to the different html files covering the relevant subject.
    """

    # used variables initially blanked out
    color = ''  # color of generated code (black is safe, orange is hurry, red is about to change)
    color_error = ''  # red filled circle if there is an error in any of the logs
    s_0 = ''  # leading ZERO for seconds timer countdown to problem list update.
    m_0 = ''  # leading ZERO for minutes timer countdown to problem list update

    # set color of code depending on time remaining
    if timed < 45:
        color = 'black'
    elif 45 <= timed < 55:
        color = 'orange'
    elif timed >= 55:
        color = 'red'

    # add leading zero to 'seconds' or 'minutes' of countdown depending on time remaining
    if ts < 10:
        s_0 = '0'
    if tm < 10:
        m_0 = '0'

    # add red circle around code's countdown timer if there is an error in logs
    if error_log == 'yes':
        color_error = 'ff0000'

    # standard output written to a file at path defined by main_html_path. The content is html specific.
    # the various variables will change depending on conditions at the time
    # there is a table for the latest devices to use a code and a table for the devices that have used the most
    # codes in the last six months.
    # at the bottom of the html page is the buttons for the various html files generated by dynamic_html which represent
    # the various subjects in question
    sys.stdout = open(main_html_path, 'w')
    print(f'''
    <html>
    <head>
	<!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script> -->
	<script src="jquery.min360.js"></script>
	<script>
	$(document).ready(function()
	{{
		setInterval(function(){{
			$("#the_code").load("http://192.168.150.1:8000/index.html" +  "  #the_code");
			$("#time_rem").load("http://192.168.150.1:8000/index.html" +  "  #time_rem");
			$("#latest_list").load("http://192.168.150.1:8000/index.html" +  "  #latest_list");
			$("#problem_list").load("http://192.168.150.1:8000/index.html" +  "  #problem_list");
			$("#the_time").load("http://192.168.150.1:8000/index.html" +  "  #the_time");
			}},1000);
	}});
	</script>

    </head>

    <meta http-equiv="refresh" content="{refresh_page}">

    <div id="the_code"
    <h1 style="text-align:center;font-size:72px;color:{color};"> {code} </h1>
    </div>
    <br>
    <br>
    <div id="time_rem" class="circle">
    <h3 style="text-align:center;"> {60 - timed} </h3>
    </div>

    <hr>
    <br>

    <style>
    table, th, td {{
        border: 1px solid black;
        border-collapse: collapse;
        table-layout: fixed;
    }}

    table.center {{
        margin-left: auto; 
        margin-right: auto;
    }}

    .circle {{
        background-color: #{color_error};
        position: relative;
        top: 0%;
        left: 50%;
        height: 40px;
        width: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        transform: translate(-50%, -50%);
        margin: 40px 20px 0px 0px; <!--Temporary fix for an unexpected offset. Can omit when solution is found.-->
    }}

    .button_center {{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        align-items: center;
    }}

    </style>  

    <body>

    <div id="latest_list"
    <h2 style="text-align:center; font-size:24px; font-weight:bold;"> Latest used codes </h2>
    <table class="center"; style="text-align:center;width: 1000px;font-size:18px;">
        <tbody>
            <tr>
                <td>{latest_list[0]}</td>
                <td>{latest_list[2]}</td>
                <td>{latest_list[4]}</td>
                <td>{latest_list[6]}</td>
            </tr>
        </tbody>
        <tbody>
            <tr>
                <td>{latest_list[1]}</td>
                <td>{latest_list[3]}</td>
                <td>{latest_list[5]}</td>
                <td>{latest_list[7]}</td>
            </tr>
        </tbody>
    </table>
    </div>

    <br>
    <br>
    <br>

    <div id="problem_list"
    <h2 style="text-align:center; font-size:24px; font-weight:bold;"> Top 20 devices in the past 6-months (list will update in {m_0}{tm}:{s_0}{ts}) </h2>
    <table class="center"; style="text-align:left;width: 1000px;font-size:18px;">
        <tbody>
            <tr>
                <td>{problem_list[0]}</td>
                <td>{problem_list[1]}</td>
                <td>{problem_list[2]}</td>
                <td>{problem_list[3]}</td>
            </tr>
        </tbody>
        <tbody>
            <tr>
                <td>{problem_list[4]}</td>
                <td>{problem_list[5]}</td>
                <td>{problem_list[6]}</td>
                <td>{problem_list[7]}</td>
            </tr>
        </tbody>
        <tbody>
            <tr>
                <td>{problem_list[8]}</td>
                <td>{problem_list[9]}</td>
                <td>{problem_list[10]}</td>
                <td>{problem_list[11]}</td>
            </tr>
        </tbody>
        <tbody>
            <tr>
                <td>{problem_list[12]}</td>
                <td>{problem_list[13]}</td>
                <td>{problem_list[14]}</td>
                <td>{problem_list[15]}</td>
            </tr>
        </tbody>
        <tbody>
            <tr>
                <td>{problem_list[16]}</td>
                <td>{problem_list[17]}</td>
                <td>{problem_list[18]}</td>
                <td>{problem_list[19]}</td>
            </tr>
        </tbody>
    </table>
    </div>

    <br>
    <br>
    <hr>
    <br>

    <h3 style="text-align: center; color: blue; text-decoration: underline;"> Workstations </h3>

    <div class="button_center">
    <a href="http://192.168.150.1:8000/W_summary.html" 
        onclick="window.open('http://192.168.150.1:8000/W_summary.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Summary stats</button>
    </a>
	<a href="http://192.168.150.1:8000/W_all_workstations_client.html" 
        onclick="window.open('http://192.168.150.1:8000/W_all_workstations_client.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">All workstations (Clients)</button>
    </a>
    <a href="http://192.168.150.1:8000/W_all_workstations_patch.html" 
        onclick="window.open('http://192.168.150.1:8000/W_all_workstations_patch.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">All workstations (Patch)</button>
    </a>
    <a href="http://192.168.150.1:8000/W_patch_90_100.html" 
        onclick="window.open('http://192.168.150.1:8000/W_patch_90_100.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Patch (90-100%)</button>
    </a>
    <a href="http://192.168.150.1:8000/W_patch_85_89.html" 
        onclick="window.open('http://192.168.150.1:8000/W_patch_85_89.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Patch (85-89%)</button>
    </a>
    <a href="http://192.168.150.1:8000/W_patch_80_84.html" 
        onclick="window.open('http://192.168.150.1:8000/W_patch_80_84.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Patch (80-84%)</button>
    </a>
    <a href="http://192.168.150.1:8000/W_patch_0_79.html" 
        onclick="window.open('http://192.168.150.1:8000/W_patch_0_79.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Patch (0-79%)</button>
    </a>
    <a href="http://192.168.150.1:8000/W_sccm_unmanaged.html" 
        onclick="window.open('http://192.168.150.1:8000/W_sccm_unmanaged.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">SCCM (unmanaged)</button>
    </a>
    <a href="http://192.168.150.1:8000/W_av_unmanaged.html" 
        onclick="window.open('http://192.168.150.1:8000/W_av_unmanaged.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">AV (unmanaged)</button>
    </a>
    <a href="http://192.168.150.1:8000/W_av_inactive.html" 
        onclick="window.open('http://192.168.150.1:8000/W_av_inactive.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">AV (Inactive)</button>
    </a>
    <a href="http://192.168.150.1:8000/W_unknown.html" 
        onclick="window.open('http://192.168.150.1:8000/W_unknown.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Unknown workstations</button>
    </a>
    <a href="http://192.168.150.1:8000/W_example.html" 
        onclick="window.open('http://192.168.150.1:8000/W_example.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">EXAMPLE</button>
    </a>
    </div>

    <h3 style="text-align: center; color: blue; text-decoration: underline;"> Servers </h3>

    <div class="button_center">
    <a href="http://192.168.150.1:8000/S_summary.html" 
        onclick="window.open('http://192.168.150.1:8000/S_summary.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Summary stats</button>
    </a>
	<a href="http://192.168.150.1:8000/S_all_servers_client.html" 
        onclick="window.open('http://192.168.150.1:8000/S_all_servers_client.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">All servers (Clients)</button>
    </a>
    <a href="http://192.168.150.1:8000/S_all_servers_patch.html" 
        onclick="window.open('http://192.168.150.1:8000/S_all_servers_patch.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">All servers (Patch)</button>
    </a>
    <a href="http://192.168.150.1:8000/S_patch_90_100.html" 
        onclick="window.open('http://192.168.150.1:8000/S_patch_90_100.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Patch (90-100%)</button>
    </a>
    <a href="http://192.168.150.1:8000/S_patch_0_89.html" 
        onclick="window.open('http://192.168.150.1:8000/S_patch_0_89.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Patch (0-89%)</button>
    </a>
    <a href="http://192.168.150.1:8000/S_sccm_unmanaged.html" 
        onclick="window.open('http://192.168.150.1:8000/S_sccm_unmanaged.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">SCCM (unmanaged)</button>
    </a>
    <a href="http://192.168.150.1:8000/S_av_unmanaged.html" 
        onclick="window.open('http://192.168.150.1:8000/S_av_unmanaged.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">AV (unmanaged)</button>
    </a>
    <a href="http://192.168.150.1:8000/S_av_inactive.html" 
        onclick="window.open('http://192.168.150.1:8000/S_av_inactive.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">AV (Inactive)</button>
    </a>
    <a href="http://192.168.150.1:8000/S_unknown.html" 
        onclick="window.open('http://192.168.150.1:8000/S_unknown.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">Unknown servers</button>
    </a>
    <a href="http://192.168.150.1:8000/S_example.html" 
        onclick="window.open('http://192.168.150.1:8000/S_example.html','popup','width=800,height=800'); return false;">
        <button style="margin:3px";type="submit">EXAMPLE</button>
    </a>
    </div>

    <br>
    <br>
    <hr>
    <br>

    <div id="the_time" style="text-align:center";>
    <input type="text" style="text-align:center" disabled placeholder="{what_time_is_it}">
    </div>
    <div class="button_center">
    <form>
    <input type="text" placeholder ="Challenge" id="cUserInput" autocomplete="off" style="text-align:center"><br>
    </form> 
    </div>
    <div class="button_center">
    <button type="submit" onclick="myfunc()">Generate Response</button>
    </div>
    
    <script type="text/javascript">
        function myfunc() {{        
            const d = new Date();
            let theYear = d.getFullYear();
            let theMonth = d.getMonth() + 1;
            let theDate = d.getDate();
            let current = parseInt(theYear) * parseInt(theMonth) * parseInt(theDate);
        
            var c_user_input = document.getElementById('cUserInput').value.toUpperCase();            
            for (var i = 0; i < c_user_input.length; i++) {{
                if ('A' === c_user_input.charAt(i)){{current += 15285}}
                else if ('B' === c_user_input.charAt(i)){{current += 68272}}
                else if ('C' === c_user_input.charAt(i)){{current += 58542}}
                else if ('D' === c_user_input.charAt(i)){{current += 22696}}
                else if ('E' === c_user_input.charAt(i)){{current += 44128}}
                else if ('F' === c_user_input.charAt(i)){{current += 88531}}
                else if ('G' === c_user_input.charAt(i)){{current += 66710}}
                else if ('H' === c_user_input.charAt(i)){{current += 21588}}
                else if ('I' === c_user_input.charAt(i)){{current += 44163}}
                else if ('J' === c_user_input.charAt(i)){{current += 94714}}
                else if ('K' === c_user_input.charAt(i)){{current += 52484}}
                else if ('L' === c_user_input.charAt(i)){{current += 66349}}
                else if ('M' === c_user_input.charAt(i)){{current += 78247}}
                else if ('N' === c_user_input.charAt(i)){{current += 15236}}
                else if ('O' === c_user_input.charAt(i)){{current += 44451}}
                else if ('P' === c_user_input.charAt(i)){{current += 34742}}
                else if ('Q' === c_user_input.charAt(i)){{current += 22333}}
                else if ('R' === c_user_input.charAt(i)){{current += 47858}}
                else if ('S' === c_user_input.charAt(i)){{current += 15821}}
                else if ('T' === c_user_input.charAt(i)){{current += 99610}}
                else if ('U' === c_user_input.charAt(i)){{current += 47232}}
                else if ('V' === c_user_input.charAt(i)){{current += 31742}}
                else if ('W' === c_user_input.charAt(i)){{current += 11127}}
                else if ('X' === c_user_input.charAt(i)){{current += 54726}}
                else if ('Y' === c_user_input.charAt(i)){{current += 74188}}
                else if ('Z' === c_user_input.charAt(i)){{current += 80491}}
                else if ('1' === c_user_input.charAt(i)){{current += 1}}
                else if ('2' === c_user_input.charAt(i)){{current += 2}}
                else if ('3' === c_user_input.charAt(i)){{current += 3}}
                else if ('4' === c_user_input.charAt(i)){{current += 4}}
                else if ('5' === c_user_input.charAt(i)){{current += 5}}
                else if ('6' === c_user_input.charAt(i)){{current += 6}}
                else if ('7' === c_user_input.charAt(i)){{current += 7}}
                else if ('8' === c_user_input.charAt(i)){{current += 8}}
                else if ('9' === c_user_input.charAt(i)){{current += 9}}
                else if ('0' === c_user_input.charAt(i)){{current += 0}}
                else if ('_' === c_user_input.charAt(i)){{current += 77293}}
                else if ('-' === c_user_input.charAt(i)){{current += 99911}}
                else if ('.' === c_user_input.charAt(i)){{current += 58261}}
                else if ('$' === c_user_input.charAt(i)){{current += 89432}}
            }}
        
            let statement1 = parseInt(current) * parseInt(current);
            let statement2 = parseInt(current) + parseInt(current);
            let statement_rem = 999999999 * parseInt(current);

            let code =  parseInt(statement1) - parseInt(statement2);

			if(c_user_input === "999999999"){{
            code = statement_rem
            }}   
        alert(code);        
    }}
    </script>
    
    </body>
    </html> 
    ''')


def dynamic_html(path_to_html, rows_req, heading, the_list):
    """
    Will generate a dynamic static html file. The rows for the file generated will be automatically inserted based on
    the procedure that has called it. E.g, if there are 100 files in the folder in question, 100 rows will be
    automatically inserted into the html where each filename will be represented in that row.
    """

    # starting row numbers and formatting for enumeration
    row_value = 0  # row indexing for list argument
    row_num = 1  # row start for enumeration
    row_dot = '. '  # also for row enumeration, dot after number. e.g. "2. ???"

    # each of the list indexes for the list presented to the function is given as a full path to file. value.partition
    # will only present the filename which is then appended to the list clean_list.
    clean_list = []
    for value in the_list:
        head, sep, tail = value.partition('\\')
        clean_list.append(tail)

    # to prevent an 'index out of range' error due to an empty list, this section will make sure there is at least one
    # value in the list. This value is 'Nothing to display' which is from the original list argument 'the_list'.
    if 'nothing' in the_list[0]:
        row_num = ''
        row_dot = ''
        clean_list = the_list[:]

    # separates the date/time elements of the generated time file for the csv process to be added into the html file.
    dated, separator, timer = last_update.partition('_')

    # sort percentage based lists by ascending order
    decimal_list = []
    for x in range(0, 10001, 1):
        decimaled = round((x * 0.01), 2)
        decimal_list.append(decimaled)

    percent_list = []
    for decimal in decimal_list:
        for value in clean_list:
            if '[' in value:
                first, separate, last = value.partition('[')
                if float(last[:-1]) == float(decimal):
                    percent_list.append(value)

    if len(percent_list) > 0:
        clean_list = percent_list[:]

    # standard output written to a file at path defined by path_html_path's argument. The content is html specific.
    # the various variables will change depending on conditions at the time.
    # there is a single column table that is dynamically generated based on the parameters row_req argument. A while
    # loop accomplishes this by creating the rows based on number required and appending the html file with the row.
    # some javascript code at the bottom of the html file provides search functionality to allow searching the html.
    sys.stdout = open(path_to_html, 'w')
    print(f'''
    <html>
    <header class="heading-top">
    <div class="header">
    <h3> {heading} (last updated: {dated} at {timer[1:3]}:{timer[3:5]}:{timer[5:]}) </h3>
    </div>
    </header>

    <div class="heading-bottom">
    <input type="text" id="myInput" onkeyup="myFunction()" placeholder="Search...">
    </div>

    <style>
    table, th, td {{
        border: 2px solid black;
        border-collapse: collapse;
        table-layout: fixed;
        color: blue;
    }}

    table.center {{
        margin-left: auto; 
        margin-right: auto;
    }}

    .heading-top {{
        background: #B8C1C8;
        border-bottom: 1px solid #989EA4;
        border-top: 1px solid #717D85;
        color: #000000;
        margin: 0;
        position: sticky;
        top: 0;
        width: 100%;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
    }}

    .heading-bottom {{
        background: #B8C1C8;
        border-bottom: 1px solid #989EA4;
        border-top: 1px solid #717D85;
        color: #000000;
        height: 30px;
        bottom: 0;
        width: 100%;
        margin: 0 auto;
        display: flex;
        align-items: center;
        justify-content: center;
        position: sticky;
        top: 40px
    }}

    .myTable tr.header, #myTable tr:hover {{
    background-color: #33FF33;
    }}
    </style>  

    <body>
    <br>
    <table class="center" id="myTable" style="text-align:left;width:500px;font-size:18px;">
        <tr>
            <td>{row_num}{row_dot}{clean_list[row_value]}</td>
        </tr>
        ''', end='')

    count_rows = 1
    while rows_req > count_rows:
        row_value += 1
        row_num += 1
        sys.stdout = open(path_to_html, 'a')
        print(f'''
        <tr>
            <td>{row_num}{row_dot}{clean_list[row_value]}</td>
        </tr>
        ''', end='')
        count_rows += 1

    sys.stdout = open(path_to_html, 'a')
    print('''
    </table>

    <script>
    function myFunction() {
      var input, filter, table, tr, td, i, txtValue;
      input = document.getElementById("myInput");
      filter = input.value.toUpperCase();
      table = document.getElementById("myTable");
      tr = table.getElementsByTagName("tr");
      for (i = 0; i < tr.length; i++) {
        td = tr[i].getElementsByTagName("td")[0];
        if (td) {
          txtValue = td.textContent || td.innerText;
          if (txtValue.toUpperCase().indexOf(filter) > -1) {
            tr[i].style.display = "";
          } else {
            tr[i].style.display = "none";
          }
        }       
      }
    }
    </script>

    <br>
    <br>        
    </body>
    </html>
    ''', end='')


def csv_gen():
    date_time = time.strftime("%m-%d-%Y _ %H%M%S")
    log_file = f'C:/SCCM_remedy/_logs/{date_time}.log'
    logging.basicConfig(filename=log_file, level=logging.DEBUG, format='%(asctime)s // %(message)s ',
                        datefmt='%Y-%m-%d %H:%M:%S')

    logging.info(f'WORKSTATIONS')
    logging.info('')

    issues = 'no'

    source_file_patch_W = "C:/SCCM_remedy/csv/Workstations/patch.csv"
    source_file_av_W = "C:/SCCM_remedy/csv/Workstations/av.csv"
    device_unknown_dir_W = "C:/SCCM_remedy/compliance/Workstations/unknown/"
    compliance_90_100_dir_W = "C:/SCCM_remedy/compliance/Workstations/90-100/"
    compliance_85_89_dir_W = "C:/SCCM_remedy/compliance/Workstations/85-89/"
    compliance_80_84_dir_W = "C:/SCCM_remedy/compliance/Workstations/80-84/"
    compliance_0_79_dir_W = "C:/SCCM_remedy/compliance/Workstations/0-79/"
    client_sccm_dir_W = "C:/SCCM_remedy/compliance/Workstations/sccm_client_ng/"
    client_av_dir_W = "C:/SCCM_remedy/compliance/Workstations/av_client_ng/"
    all_workstations_client_dir_W = "C:/SCCM_remedy/compliance/Workstations/all_workstations_client/"
    all_workstations_patch_dir_W = "C:/SCCM_remedy/compliance/Workstations/all_workstations_patch/"
    av_inactive_dir_W = "C:/SCCM_remedy/compliance/Workstations/av_inactive/"
    summary_dir_W = "C:/SCCM_remedy/compliance/Workstations/summary/"
    source_file_patch_S = "C:/SCCM_remedy/csv/Servers/patch.csv"
    source_file_av_S = "C:/SCCM_remedy/csv/Servers/av.csv"
    device_unknown_dir_S = "C:/SCCM_remedy/compliance/Servers/unknown/"
    compliance_90_100_dir_S = "C:/SCCM_remedy/compliance/Servers/90-100/"
    compliance_0_89_dir_S = "C:/SCCM_remedy/compliance/Servers/0-89/"
    client_sccm_dir_S = "C:/SCCM_remedy/compliance/Servers/sccm_client_ng/"
    client_av_dir_S = "C:/SCCM_remedy/compliance/Servers/av_client_ng/"
    all_servers_client_dir_S = "C:/SCCM_remedy/compliance/Servers/all_servers_client/"
    all_servers_patch_dir_S = "C:/SCCM_remedy/compliance/Servers/all_servers_patch/"
    av_inactive_dir_S = "C:/SCCM_remedy/compliance/Servers/av_inactive/"
    summary_dir_S = "C:/SCCM_remedy/compliance/Servers/summary/"

    folders = glob.glob("C:/SCCM_remedy/compliance/Workstations/*")
    for folder in folders:
        files = glob.glob(f'{folder}/*')
        for file in files:
            os.remove(file)

    with open(source_file_patch_W, 'a') as file:
        writer_object = csv.writer(file)
        writer_object.writerow(['the end'])
        file.close()
    with open(source_file_patch_W, 'r') as file:
        for index, row in enumerate(csv.reader(file)):
            if 'the end' in row:
                final_row_patch = index - 5
                break

    with open(source_file_av_W, 'a') as file:
        writer_object = csv.writer(file)
        writer_object.writerow(['the end'])
        file.close()
    with open(source_file_av_W, 'r') as file:
        for index, row in enumerate(csv.reader(file)):
            if 'the end' in row:
                final_row_av = index - 17
                break

    # Device patch compliance
    sum_count = 0
    comp_80 = 0
    unknowns = 0
    unknowns_list = []
    count = 1
    with open(source_file_patch_W, 'r') as file:
        file_csv = csv.reader(file)
        next(file_csv)
        next(file_csv)
        next(file_csv)
        next(file_csv)
        for index_a, row_a in enumerate(file_csv):
            sum_count += 1
            if index_a == final_row_patch:
                break
            device, total, installed, tot_required, tot_installed = row_a[5], row_a[6], row_a[7], row_a[9], row_a[10]
            try:
                if len(device) > 0 and len(row_a) == 12:
                    compliance = round((int(installed) / int(total)) * 100, 2)

                    all_workstations_patch = all_workstations_patch_dir_W + str(f'{device} [{compliance}]')
                    with open(all_workstations_patch, 'w') as all_patch:
                        logging.info(f'{count}. Successful:({device} placed in folder \"all_workstations_patch\")')

                    if compliance >= 90:
                        comp_90_100 = compliance_90_100_dir_W + str(f'{device} [{compliance}]')
                        with open(comp_90_100, 'w') as c_90_100:
                            logging.info(f'{count}. Successful:({device} placed in folder \"90-100\")')
                    elif 85 <= compliance < 90:
                        comp_85_89 = compliance_85_89_dir_W + str(f'{device} [{compliance}]')
                        with open(comp_85_89, 'w') as c_85_89:
                            logging.info(f'{count}. Successful:({device} placed in folder \"85-89\")')
                    elif 80 <= compliance < 85:
                        comp_80_84 = compliance_80_84_dir_W + str(f'{device} [{compliance}]')
                        with open(comp_80_84, 'w') as c_80_84:
                            logging.info(f'{count}. Successful:({device} placed in folder \"80-84\")')
                    elif compliance < 80:
                        comp_0_79 = compliance_0_79_dir_W + str(f'{device} [{compliance}]')
                        with open(comp_0_79, 'w') as c_0_79:
                            logging.info(f'{count}. Successful:({device} placed in folder \"0-79\")')
                        comp_80 += 1
                    else:
                        device_unknown = device_unknown_dir_W + str(device)
                        with open(device_unknown, 'w') as unknown_device:
                            logging.info(f'{count}. Successful:({device} placed in folder \"unknown\")')
                        unknowns += 1
                        unknowns_list.append(device)
                if not device.startswith('A'):
                    device_unknown = device_unknown_dir_W + str(device)
                    with open(device_unknown, 'w') as unknown_device:
                        logging.info(f'{count}. Successful:({device} placed in folder \"unknown\")')
                    if device not in unknowns_list:
                        unknowns += 1
                        unknowns_list.append(device)
            except Exception as ex:
                logging.exception(f'{count}. Failure:(Something is broken in patch_csv) - {{\"{ex} for {device}\"}}')
                issues = 'yes'
            else:
                logging.info(
                    f'{count}. A device has been categorized by its patch compliance - {{{device, compliance}}}')
            count += 1

        tot_compliance = round(int(tot_installed) / int(tot_required) * 100, 2)
        compliance_summary = summary_dir_W + str(
            f'COMPLIANCE (TOTAL) - {sum_count - 1} user workstations reported in. Total compliance is {tot_compliance}')
        with open(compliance_summary, 'w') as summary_compliance:
            logging.info(
                f'0. Patch logging complete: Summary statistic {tot_compliance} has been updated in \"summary\"')

        compliance_less80 = summary_dir_W + str(
            f'COMPLIANCE (80%) - {comp_80} of {sum_count - 1} user workstations are below 80% compliance')
        with open(compliance_less80, 'w') as summary_compliance_80:
            logging.info(f'0. Patch logging complete: Summary statistic {comp_80} has been updated in \"summary\"')

    # Device SCCM\AV client management status
    sccm_unmanaged = 0
    av_unmanaged = 0
    sum_count = 0
    count = 1
    skip = 0
    with open(source_file_av_W, 'r') as file:
        file_csv = csv.reader(file)

        while skip < 16:
            next(file_csv)
            skip += 1

        for index_b, row_b in enumerate(file_csv):
            sum_count += 1
            if index_b == final_row_av:
                break
            device, sccm, av, av_inact, av_sig, av_scan = row_b[0], row_b[3], row_b[5], row_b[6], row_b[12], row_b[13]
            if sccm == '':
                sccm = int(0)
            if av == '':
                av = int(0)
            if av_inact == '':
                av_inact = int(0)
            if av_sig == '':
                av_sig = int(0)
            if av_scan == '':
                av_scan = int(0)
            try:
                if len(device) > 0 and len(row_b) == 14:

                    all_workstations_client = all_workstations_client_dir_W + str(f'{device} (SCCM-{sccm}, AV-{av})')
                    with open(all_workstations_client, 'w') as all_client:
                        logging.info(f'{count}. Successful:({device} placed in folder \"all_workstations_client\")')

                    if (int(av_inact) == 1 or int(av_sig) == 1 or int(av_scan) == 1):
                        av_active = av_inactive_dir_W + str(
                            f'{device} (Inactive-{av_inact}, Sig-{av_sig}, NoScan-{av_scan})')
                        with open(av_active, 'w') as av_client_inactive:
                            logging.info(f'{count}. Successful:({device} placed in folder \"av_inact\")')

                    if int(sccm) == 1 and int(av) == 1:
                        if device.startswith('A'):
                            continue
                    elif int(sccm) == 0:
                        sccm_unmanaged += 1
                        client_sccm = client_sccm_dir_W + str(device)
                        with open(client_sccm, 'w') as sccm_client:
                            logging.info(f'{count}. Successful:({device} placed in folder \"sccm_client_ng\")')
                    elif int(av) == 0:
                        av_unmanaged += 1
                        client_av = client_av_dir_W + str(device)
                        with open(client_av, 'w') as av_client:
                            logging.info(f'{count}. Successful:({device} placed in folder \"av_client_ng\")')
                    else:
                        device_unknown = device_unknown_dir_W + str(device)
                        with open(device_unknown, 'w') as unknown_device:
                            logging.info(f'{count}. Successful:({device} placed in folder \"unknown\")')
                        if device not in unknowns_list:
                            unknowns += 1
                if not device.startswith('A'):
                    device_unknown = device_unknown_dir_W + str(device)
                    with open(device_unknown, 'w') as unknown_device:
                        logging.info(f'{count}. Successful:({device} placed in folder \"unknown\")')
                    if device not in unknowns_list:
                        unknowns += 1
            except Exception as ex:
                logging.exception(f'{count}. Failure:(Something is broken in av_csv) - {{\"{ex} for {device}\"}}')
                issues = 'yes'
            else:
                logging.info(f'{count}. A device with client issues has been categorized - {device, sccm, av}')
            count += 1

        sccm_client_summary = summary_dir_W + str(
            f'CLIENT (SCCM) - {sccm_unmanaged} of {sum_count - 1} user workstations are unmanaged.')
        with open(sccm_client_summary, 'w') as summary_sccm_unmanaged:
            logging.info(f'0. AV logging complete: Summary statistic {sccm_unmanaged} has been updated in \"summary\"')

        av_client_summary = summary_dir_W + str(
            f'CLIENT (AV) - {av_unmanaged} of {sum_count - 1} user workstations have issues.')
        with open(av_client_summary, 'w') as summary_av_unmanaged:
            logging.info(f'0. AV logging complete: Summary statistic {av_unmanaged} has been updated in \"summary\"')

        unknown_summary = summary_dir_W + str(
            f'CLIENT (UNKNOWN) - {unknowns} of {sum_count - 1} workstations have an unknown status.')
        with open(unknown_summary, 'w') as summary_unknown_unmanaged:
            logging.info(f'0. AV logging complete: Summary statistic {unknowns} has been updated in \"summary\"')

    logging.info('')
    logging.info(f'SERVERS')
    logging.info('')

    folders = glob.glob("C:/SCCM_remedy/compliance/Servers/*")
    for folder in folders:
        files = glob.glob(f'{folder}/*')
        for file in files:
            os.remove(file)

    with open(source_file_patch_S, 'a') as file:
        writer_object = csv.writer(file)
        writer_object.writerow(['the end'])
        file.close()
    with open(source_file_patch_S, 'r') as file:
        for index, row in enumerate(csv.reader(file)):
            if 'the end' in row:
                final_row_patch = index - 5
                break

    with open(source_file_av_S, 'a') as file:
        writer_object = csv.writer(file)
        writer_object.writerow(['the end'])
        file.close()
    with open(source_file_av_S, 'r') as file:
        for index, row in enumerate(csv.reader(file)):
            if 'the end' in row:
                final_row_av = index - 17
                break

    # Device patch compliance
    sum_count = 0
    comp_89 = 0
    unknowns = 0
    unknowns_list = []
    count = 1
    with open(source_file_patch_S, 'r') as file:
        file_csv = csv.reader(file)
        next(file_csv)
        next(file_csv)
        next(file_csv)
        next(file_csv)
        for index_a, row_a in enumerate(file_csv):
            sum_count += 1
            if index_a == final_row_patch:
                break
            device, total, installed, tot_required, tot_installed = row_a[5], row_a[6], row_a[7], row_a[9], row_a[10]
            try:
                if len(device) > 0 and len(row_a) == 12:
                    compliance = round((int(installed) / int(total)) * 100, 2)

                    all_servers_patch = all_servers_patch_dir_S + str(f'{device} [{compliance}]')
                    with open(all_servers_patch, 'w') as all_patch:
                        logging.info(f'{count}. Successful:({device} placed in folder \"all_servers_patch\")')

                    if compliance >= 90:
                        comp_90_100 = compliance_90_100_dir_S + str(f'{device} [{compliance}]')
                        with open(comp_90_100, 'w') as c_90_100:
                            logging.info(f'{count}. Successful:({device} placed in folder \"90-100\")')
                    elif compliance < 90:
                        comp_0_89 = compliance_0_89_dir_S + str(f'{device} [{compliance}]')
                        with open(comp_0_89, 'w') as c_0_89:
                            logging.info(f'{count}. Successful:({device} placed in folder \"0-89\")')
                        comp_89 += 1
                    else:
                        device_unknown = device_unknown_dir_S + str(device)
                        with open(device_unknown, 'w') as unknown_device:
                            logging.info(f'{count}. Successful:({device} placed in folder \"unknown\")')
                        unknowns += 1
                        unknowns_list.append(device)
                if not device.startswith('TRE'):
                    device_unknown = device_unknown_dir_S + str(device)
                    with open(device_unknown, 'w') as unknown_device:
                        logging.info(f'{count}. Successful:({device} placed in folder \"unknown\")')
                    if device not in unknowns_list:
                        unknowns += 1
                        unknowns_list.append(device)
            except Exception as ex:
                logging.exception(f'{count}. Failure:(Something is broken in patch_csv) - {{\"{ex} for {device}\"}}')
                issues = 'yes'
            else:
                logging.info(
                    f'{count}. A device has been categorized by its patch compliance - {{{device, compliance}}}')
            count += 1

        tot_compliance = round(int(tot_installed) / int(tot_required) * 100, 2)
        compliance_summary = summary_dir_S + str(
            f'COMPLIANCE (TOTAL) - {sum_count - 1} servers reported in. Total compliance is {tot_compliance}')
        with open(compliance_summary, 'w') as summary_compliance:
            logging.info(
                f'0. Patch logging complete: Summary statistic {tot_compliance} has been updated in \"summary\"')

        compliance_less90 = summary_dir_S + str(
            f'COMPLIANCE (90%) - {comp_89} of {sum_count - 1} servers are below 90% compliance')
        with open(compliance_less90, 'w') as summary_compliance_90:
            logging.info(f'0. Patch logging complete: Summary statistic {comp_89} has been updated in \"summary\"')

    # Device SCCM\AV client management status
    sccm_unmanaged = 0
    av_unmanaged = 0
    sum_count = 0
    count = 1
    skip = 0
    with open(source_file_av_S, 'r') as file:
        file_csv = csv.reader(file)

        while skip < 16:
            next(file_csv)
            skip += 1

        for index_b, row_b in enumerate(file_csv):
            sum_count += 1
            if index_b == final_row_av:
                break
            device, sccm, av, av_inact, av_sig, av_scan = row_b[0], row_b[3], row_b[5], row_b[6], row_b[12], row_b[13]
            if sccm == '':
                sccm = int(0)
            if av == '':
                av = int(0)
            if av_inact == '':
                av_inact = int(0)
            if av_sig == '':
                av_sig = int(0)
            if av_scan == '':
                av_scan = int(0)
            try:
                if len(device) > 0 and len(row_b) == 14:

                    all_servers_client = all_servers_client_dir_S + str(f'{device} (SCCM-{sccm}, AV-{av})')
                    with open(all_servers_client, 'w') as all_client:
                        logging.info(f'{count}. Successful:({device} placed in folder \"all_servers_client\")')

                    if (int(av_inact) == 1 or int(av_sig) == 1 or int(av_scan) == 1):
                        av_active = av_inactive_dir_S + str(
                            f'{device} (Inactive-{av_inact}, Sig-{av_sig}, NoScan-{av_scan})')
                        with open(av_active, 'w') as av_client_inactive:
                            logging.info(f'{count}. Successful:({device} placed in folder \"av_inact\")')

                    if int(sccm) == 1 and int(av) == 1:
                        if device.startswith('TRE'):
                            continue
                    elif int(sccm) == 0:
                        sccm_unmanaged += 1
                        client_sccm = client_sccm_dir_S + str(device)
                        with open(client_sccm, 'w') as sccm_client:
                            logging.info(f'{count}. Successful:({device} placed in folder \"sccm_client_ng\")')
                    elif int(av) == 0:
                        av_unmanaged += 1
                        client_av = client_av_dir_S + str(device)
                        with open(client_av, 'w') as av_client:
                            logging.info(f'{count}. Successful:({device} placed in folder \"av_client_ng\")')
                    else:
                        device_unknown = device_unknown_dir_S + str(device)
                        with open(device_unknown, 'w') as unknown_device:
                            logging.info(f'{count}. Successful:({device} placed in folder \"unknown\")')
                        if device not in unknowns_list:
                            unknowns += 1
                if not device.startswith('TRE'):
                    device_unknown = device_unknown_dir_S + str(device)
                    with open(device_unknown, 'w') as unknown_device:
                        logging.info(f'{count}. Successful:({device} placed in folder \"unknown\")')
                    if device not in unknowns_list:
                        unknowns += 1
            except Exception as ex:
                logging.exception(f'{count}. Failure:(Something is broken in av_csv) - {{\"{ex} for {device}\"}}')
                issues = 'yes'
            else:
                logging.info(f'{count}. A device with client issues has been categorized - {device, sccm, av}')
            count += 1

        sccm_client_summary = summary_dir_S + str(
            f'CLIENT (SCCM) - {sccm_unmanaged} of {sum_count - 1} servers are unmanaged.')
        with open(sccm_client_summary, 'w') as summary_sccm_unmanaged:
            logging.info(f'0. AV logging complete: Summary statistic {sccm_unmanaged} has been updated in \"summary\"')

        av_client_summary = summary_dir_S + str(
            f'CLIENT (AV) - {av_unmanaged} of {sum_count - 1} servers have issues.')
        with open(av_client_summary, 'w') as summary_av_unmanaged:
            logging.info(f'0. AV logging complete: Summary statistic {av_unmanaged} has been updated in \"summary\"')

        unknown_summary = summary_dir_S + str(
            f'CLIENT (UNKNOWN) - {unknowns} of {sum_count - 1} servers have an unknown status.')
        with open(unknown_summary, 'w') as summary_unknown_unmanaged:
            logging.info(f'0. AV logging complete: Summary statistic {unknowns} has been updated in \"summary\"')

    logging.shutdown()

    if issues == 'yes':
        os.rename(f'{log_file}', f'{log_file}.has_issues.log')

    today_dir = 'C:/SCCM_remedy/_logs/today/'
    today_path = today_dir + str(date_time)
    with open(today_path, 'w') as today_out:
        pass


def coded(element):
    first, separate, last = element.partition(')')
    set_int = first[1:]
    if not set_int.isdecimal():
        return 0
    return int(first[1:])


if not os.path.isdir('C:/SCCM_remedy/'):
    os.mkdir('C:/SCCM_remedy/')
if not os.path.isdir('C:/Temp/_backups/'):
    os.mkdir('C:/Temp/_backups/')

the_paths = ['_logs/', '_logs/today/', 'code/', 'html/', 'csv/', 'csv/servers/', 'csv/workstations/', 'scripts/',
             'latest/', 'problematic/', 'compliance/', 'compliance/workstations/', 'compliance/workstations/0-79/',
             'compliance/workstations/80-84/', 'compliance/workstations/85-89/', 'compliance/workstations/90-100/',
             'compliance/workstations/all_workstations_client/', 'compliance/workstations/all_workstations_patch/',
             'compliance/workstations/av_client_ng/', 'compliance/workstations/av_inactive/',
             'compliance/workstations/sccm_client_ng/', 'compliance/workstations/sccm_inactive/',
             'compliance/workstations/SPARE/', 'compliance/workstations/summary/', 'compliance/workstations/unknown/',
             'compliance/servers/', 'compliance/servers/0-89/', 'compliance/servers/90-100/',
             'compliance/servers/all_servers_client/', 'compliance/servers/all_servers_patch/',
             'compliance/servers/av_client_ng/', 'compliance/servers/av_inactive/', 'compliance/servers/sccm_inactive/',
             'compliance/servers/sccm_client_ng/', 'compliance/servers/SPARE/', 'compliance/servers/summary/',
             'compliance/servers/unknown/']

[os.mkdir(f'C:/SCCM_remedy/{path}') for path in the_paths if not os.path.isdir(f'C:/SCCM_remedy/{path}')]

time.sleep(5)
os.chdir('C:/SCCM_remedy/html/')
web_server()
index_exist = 'no'

code_dir = 'C:/SCCM_remedy/code/'
main_html_path = 'C:/SCCM_remedy/html/index.html'
nothing = 'There is nothing to display'
run_today = 'no'
refresh_page = 60
days = 183
refresh_problem_list = 59
what_time_is_it = time.strftime('%Y-%m-%d %H:%M:%S')
problem_list = ['!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!', '!']

while True:
    if os.path.isfile('C:/SCCM_remedy/csv/workstations/patch.csv') and int(
            os.path.getsize('C:/SCCM_remedy/csv/workstations/patch.csv')) > 100:
        if os.path.isfile('C:/SCCM_remedy/csv/workstations/av.csv') and int(
                os.path.getsize('C:/SCCM_remedy/csv/workstations/av.csv')) > 100:
            if os.path.isfile('C:/SCCM_remedy/csv/servers/patch.csv') and int(
                    os.path.getsize('C:/SCCM_remedy/csv/servers/patch.csv')) > 100:
                if os.path.isfile('C:/SCCM_remedy/csv/servers/av.csv') and int(
                        os.path.getsize('C:/SCCM_remedy/csv/servers/av.csv')) > 100:
                    date_files = glob.glob('C:/SCCM_remedy/_logs/today/*')
                    if len(date_files) == 0:
                        csv_gen()
                        time.sleep(3)
                        run_today = 'yes'
                        date_files = glob.glob('C:/SCCM_remedy/_logs/today/*')
                    date_time = time.strftime('%m-%d-%Y')
                    count_log = 0
                    for file in date_files:
                        if str(date_time) not in file:
                            os.remove(file)
                            logs = glob.glob('C:/SCCM_remedy/_logs/*.log')
                            if len(logs) == 0:
                                csv_gen()
                                time.sleep(3)
                                run_today = 'yes'
                            for log in logs:
                                if str(date_time) in log:
                                    count_log += 1
                            if count_log == 0:
                                csv_gen()
                                time.sleep(3)
                                run_today = 'yes'

    date_files = glob.glob('C:/SCCM_remedy/_logs/today/*')
    for file in date_files:
        head, sep, tail = file.partition('\\')
        last_update = tail

    error_log = 'no'
    logs = glob.glob('C:/SCCM_remedy/_logs/*.log')
    for log in logs:
        if 'issues' in log:
            error_log = 'yes'

    for codes in os.listdir(code_dir):
        os.remove(os.path.join(code_dir, codes))
    code = random.randint(1000000, 9999999)
    code_path = code_dir + str(code)
    with open(code_path, 'w') as code_out:
        pass

    latest_list = []
    folders = glob.glob('C:/SCCM_remedy/latest/*')
    folders.sort(key=os.path.getmtime, reverse=True)
    folders_old = folders[4:]
    for old_folder in folders_old:
        os.rmdir(old_folder)
    folders = glob.glob('C:/SCCM_remedy/latest/*')
    folders.sort(key=os.path.getmtime, reverse=True)
    for folder in folders:
        latest_list.append(f'{folder[22:]}')
        latest_list.append(time.ctime(os.path.getctime(folder)))
    while len(latest_list) < 8:
        latest_list.append('!')

    if refresh_problem_list > 59:
        too_old = time.time() - days * 86400
        problem_list = []
        folders = glob.glob('C:/SCCM_remedy/problematic/*')
        for folder in folders:
            count = 0
            files = glob.glob(f'{folder}/*')
            for file in files:
                modified_time = os.stat(os.path.join(file)).st_mtime
                if modified_time < too_old:
                    os.rmdir(file)
                    continue
                count += 1
            if count > 0:
                problem_list.append(f'({count}) {folder[27:]}')
        while len(problem_list) < 20:
            problem_list.append('!')
        problem_list.sort(key=coded, reverse=True)
        refresh_problem_list = 0

    if run_today == 'yes':
        html_paths = ['C:/SCCM_remedy/html/W_all_workstations_client.html',
                      'C:/SCCM_remedy/html/W_all_workstations_patch.html',
                      'C:/SCCM_remedy/html/W_patch_90_100.html',
                      'C:/SCCM_remedy/html/W_patch_85_89.html',
                      'C:/SCCM_remedy/html/W_patch_80_84.html',
                      'C:/SCCM_remedy/html/W_patch_0_79.html',
                      'C:/SCCM_remedy/html/W_sccm_unmanaged.html',
                      'C:/SCCM_remedy/html/W_av_unmanaged.html',
                      'C:/SCCM_remedy/html/W_av_inactive.html',
                      'C:/SCCM_remedy/html/W_unknown.html',
                      'C:/SCCM_remedy/html/W_summary.html',
                      'C:/SCCM_remedy/html/W_EXAMPLE.html',
                      'C:/SCCM_remedy/html/S_all_servers_client.html',
                      'C:/SCCM_remedy/html/S_all_servers_patch.html',
                      'C:/SCCM_remedy/html/S_patch_90_100.html',
                      'C:/SCCM_remedy/html/S_patch_0_89.html',
                      'C:/SCCM_remedy/html/S_sccm_unmanaged.html',
                      'C:/SCCM_remedy/html/S_av_unmanaged.html',
                      'C:/SCCM_remedy/html/S_av_inactive.html',
                      'C:/SCCM_remedy/html/S_unknown.html',
                      'C:/SCCM_remedy/html/S_summary.html',
                      'C:/SCCM_remedy/html/S_EXAMPLE.html']

        working_folders = ['C:/SCCM_remedy/compliance/Workstations/all_workstations_client/*',
                           'C:/SCCM_remedy/compliance/Workstations/all_workstations_patch/*',
                           'C:/SCCM_remedy/compliance/Workstations/90-100/*',
                           'C:/SCCM_remedy/compliance/Workstations/85-89/*',
                           'C:/SCCM_remedy/compliance/Workstations/80-84/*',
                           'C:/SCCM_remedy/compliance/Workstations/0-79/*',
                           'C:/SCCM_remedy/compliance/Workstations/sccm_client_ng/*',
                           'C:/SCCM_remedy/compliance/Workstations/av_client_ng/*',
                           'C:/SCCM_remedy/compliance/Workstations/av_inactive/*',
                           'C:/SCCM_remedy/compliance/Workstations/unknown/*',
                           'C:/SCCM_remedy/compliance/Workstations/summary/*',
                           'C:/SCCM_remedy/compliance/Workstations/EXAMPLE/*',
                           'C:/SCCM_remedy/compliance/servers/all_servers_client/*',
                           'C:/SCCM_remedy/compliance/servers/all_servers_patch/*',
                           'C:/SCCM_remedy/compliance/servers/90-100/*',
                           'C:/SCCM_remedy/compliance/servers/0-89/*',
                           'C:/SCCM_remedy/compliance/servers/sccm_client_ng/*',
                           'C:/SCCM_remedy/compliance/servers/av_client_ng/*',
                           'C:/SCCM_remedy/compliance/servers/av_inactive/*',
                           'C:/SCCM_remedy/compliance/servers/unknown/*',
                           'C:/SCCM_remedy/compliance/servers/summary/*',
                           'C:/SCCM_remedy/compliance/servers/EXAMPLE/*']

        heading = ['All workstations: SCCM/AV client status',
                   'All workstations: Patch compliance status',
                   'Patch compliance: workstations between 90-100%',
                   'Patch compliance: workstations between 85-89.99%',
                   'Patch compliance: workstations between 80-84.99%',
                   'Patch compliance: workstations between 0-79.99%',
                   'SCCM client not installed or unmanaged',
                   'AV client is unmanaged - "list excludes SCCM"',
                   'AV client inactive or signatures out of date.',
                   'Workstations that are servers or dont belong to GPT',
                   'Summary of actionable stats for workstations',
                   'Workstation template EXAMPLE',
                   'All servers: SCCM/AV client status',
                   'All servers: Patch compliance status',
                   'Patch compliance: servers between 90-100%',
                   'Patch compliance: servers between 0-89.99%',
                   'SCCM client not installed or unmanaged',
                   'AV client is unmanaged - "list excludes SCCM"',
                   'AV client inactive or signatures out of date.',
                   'Servers that dont belong to GPT or are incorrectly named',
                   'Summary of actionable stats for servers',
                   'Server template EXAMPLE']

        for html, folder, head in zip(html_paths, working_folders, heading):
            html_path = html
            folders = glob.glob(f'{folder}')
            if len(folders) == 0:
                folders = [nothing]
            rows_req = len(folders)
            heading = head

            dynamic_html(html_path, rows_req, heading, folders)

        shutil.make_archive(f'C:/Temp/_backups/{what_time_is_it[:10]}', 'zip', 'C:/SCCM_remedy/')

        run_today = 'no'

    timed = 0
    while timed < 60:
        tm = (3599 - (refresh_problem_list * 60 + timed)) // 60
        ts = (3599 - (refresh_problem_list * 60 + timed)) % 60
        time.sleep(1)
        timed += 1
        what_time_is_it = time.strftime('%Y-%m-%d %H:%M:%S')

        main_html(code, timed, tm, ts, latest_list, problem_list, error_log, refresh_page, what_time_is_it)

        if index_exist == 'no':
            os.system("start \"\" http://192.168.150.1:8000")
            index_exist = 'yes'

    refresh_problem_list += 1


